# -*- coding: utf-8 -*-
"""
Created on Sat Sept 19 12:00:00 2015

@author: Julian

extract relevant scans from Spectra files and
plot results in various ways
"""



import numpy as np
import matplotlib.pyplot as plt
import xrayutilities as xu
import os.path
import numpy
import scipy as sp
import os
import h5py
import codecs


def CenOfMass(qx, qz, INT, roi):
    #Calculate the center of mass, for a give qx,qz, Int array and a roi in % arround center, returs a vector  
    qxs = 0.0
    qzs = 0.0
    qx_cen=0
    qz_cen=0
    var1 = 0
    var2 = 0
    rqx1=0
    rqx2=0
    rqz1=0
    rqz2=0
    int_ges=0.0
    
    #Find max. Int for Center Point of roi
    temp_arr = np.where(INT == INT.max());
    qz_cen = temp_arr[0][0]
    qx_cen = temp_arr[1][0]
    
    if roi==1:
        rqx1=0
        rqx2=qx.shape[0]
        rqz1=0
        rqz2=qz.shape[0]
    elif roi>1.:
        print("ROI for center of mass cannot be larger than 1!")
    else:
        rqx1=int(qx_cen-(roi*qx.shape[0]/2))
        rqx2=int(qx_cen+(roi*qx.shape[0]/2))
        rqz1=int(qz_cen-(roi*qz.shape[0]/2))
        rqz2=int(qz_cen+(roi*qz.shape[0]/2))  
        
    for var1 in range(rqx1,rqx2):
        
        for var2 in range(rqz1,rqz2):
            
            qxs=qxs+qx[var1]*INT[var2][var1]
            qzs=qzs+qz[var2]*INT[var2][var1]
            int_ges = int_ges +  INT[var2][var1]
            
    qxs = qxs/int_ges
    qzs = qzs/int_ges
    qs = np.array([qxs,qzs])
    
    return qs;


def check_filform(filepath):
    
    files = os.listdir(filepath)
    
    data = []
    for file in files:

        X = []
        with codecs.open(os.path.join(filepath,file), encoding='utf-8-sig') as f:
            X = [[float(x) for x in line.split()] for line in f]
        X = np.array(X)
        data.append(X[:,1])
        
    data = np.fliplr(np.array(data))  
    
    return (data)


def create_header(filefio):
    
    
    #Ceate Motor dictionary
    # Empty dictionary
    mot_counters = {}
    # Create entry for header indormation/motors
    mot_counters["header"] = []
    
    # Open file
    Data_from_FIO = open(filefio, 'r')
    
    #Count the number of of scan-points
    num_of_points = 0 
    for line in Data_from_FIO:
        if line[0] == " ":
            try: 
                #Check if second last charachter in this line is a number, if so increase counter
                float(line[-2])
                num_of_points = num_of_points+1
            except ValueError:
                num_of_points = num_of_points+0
                
    #Re-open file again to set line-counter to zero
    Data_from_FIO = open(filefio, 'r')
    
    #Set count variable for lines
    count=0         
    
    for line in Data_from_FIO:
        
        #Create motor-entries in dictionary mot_counters:
        if line[0]!=" " and line[0]!="!" and line[0]!="%" and count>13:
            columns = line.split()
            value_of_motor = np.float(columns[2])
            name_of_mot = columns[0]
            mot_counters[name_of_mot] = numpy.full(num_of_points, value_of_motor, dtype=float)
            count=count+1
            
        else:
            try:
                line.split().index("Col") #Check for Col description
                line = line.strip()
                columns = line.split()
                mot_counters["header"].append(columns[2]) #Store Col varaible in haeder
                mot_counters[columns[2]]=[]  #Create empty entry in dictionory according to Col variable  
                count=count+1
    
            except ValueError:
                columns = line.split()
                
            try:
                np.float(line.split()[0])
                header_count=0
                for i in columns:
                    mot_counters[mot_counters['header'][header_count]].append(np.float(i))
                    header_count = header_count + 1
                count=count+1
                
            except ValueError:
                count=count+1
    
    return(mot_counters)





plt.close("all") # remove all old open plot windows

# some definitions
incr = 10    # intensity increment to plot multiple scans

tickf = 28
labf = 28
plt.rcParams.update({'font.size': 28})
plt.rcParams['image.cmap'] = 'jet'

plt.rcParams.update({'font.sans-serif': "Arial",
                     'font.family': "sans-serif",
                     'font.size' : 28,                   
                    })

 
white_text = 23

#lower and upper limit for LOG
log_l = 0.0
log_u = 4.5

log_l_clim = 0.5
log_u_clim = 5.0

titf = 10
lw = 0.8
fontinset = 28
fontinset = 28
#plotinset = True

#Saves figures if set to "True"
sav = False
sav_LC = False
format = "png"
dpi = 100

# detector parameters
cch = 639.15
chpdeg = -309.94
roi1=[630,650] # for integration of PSD ROI1
roi2=[0,1280]  # for gridding in Q-space
#roi2=[200,1000]

# Energy
energy=15000  # eV

plfont = {'fontname':'Arial'}

GaAs = xu.materials.GaAs
Si = xu.materials.Si
Ge = xu.materials.Ge
GaAsWZ = xu.materials.Crystal.fromCIF(os.path.join("CIF", "GaAs_hex.cif"))


expcub = xu.HXRD(GaAs.Q(1,-1,0),GaAs.Q(1,1,1), geometry='lo_hi',wl=xu.lam2en(energy))
expwz = xu.HXRD(GaAsWZ.Q(1,0,0),GaAsWZ.Q(0,0,1), geometry='lo_hi',wl=xu.lam2en(energy))

#Define the path, sample-name
path=".\\raw\\"

qx444,qy444,qz444=expcub.Transform(GaAs.Q(4,4,4))
qx444ge,qy444ge,qz444ge=expcub.Transform(Ge.Q(4,4,4))
qx335,qy335,qz335=expcub.Transform(GaAs.Q(3,3,5))

qx008wz,qy008wz,qz008wz=expwz.Transform(GaAsWZ.Q(0,0,8))


##########################################################################################################
#-------------------100%-Ge  108-az-448------------------------------------------------------------------------------
##########################################################################################################
sample = 'GaAs_Ge_NW_2ndday'
samplename = 'GaAs-Cores-Ge-Shell_h05804'

    
titlestr = sample+" (108) az(448)"
scannr ='00250'
fign='1'


[uom, dummy, dummy , utt] = expcub.Q2Ang([0, -3.6182928593213926, 10.275417622535391], geometry = "real", trans=False)
[omth,dummy,dummy,ttth] = expcub.Q2Ang(GaAs.Q(4,4,8))
omoff448 = uom-omth
ttoff448 = utt-ttth


#Combine Path + Filename
fnamefio='%s_%s'%(sample,scannr)

#Open FIO file    
filefio=os.path.join(path, fnamefio+".fio")
fiodata=os.path.join(path,sample+"_"+scannr,"mythen")

#Get Motor Values and detector images
mot_counters = []
mca_raw = []
mot_counters = create_header(filefio)
mca_raw = check_filform(fiodata)

#config psd
#RA_normalizer_psd = xu.IntensityNormalizer("MCA",time="Seconds",absfun=lambda d: d['filtfactor'])
expcub.Ang2Q.init_linear('z+',cch,1280.,chpdeg=chpdeg,roi=roi2)

om = np.array(mot_counters["om"])
tt = np.array(mot_counters["tt"])

#Same delta as for 448 reflection!!!!
[qx108_az448,qy108_az448,qz108_az448] = expcub.Ang2Q.linear(om,tt,roi=roi2,delta=[omoff448,ttoff448])
#[qx_az448,qy_az448,qz_az448] = expcub.Ang2Q.linear(om,tt,roi=roi2)
#convert to RSM


gridderSym = xu.FuzzyGridder2D(1200,1250)
#gridderSym.KeepData(True)

mca_raw108_az448 = xu.blockAveragePSD(mca_raw, 1, roi=roi2)

gridderSym(qy108_az448,qz108_az448,mca_raw108_az448[:,roi2[0]:roi2[1]])
#gridderSym(qy,qz,mca_raw)

qxq108 = gridderSym.xaxis
qzq108 = gridderSym.yaxis
INT108 = xu.maplog(gridderSym.data.transpose(),3.5, 0.0)
#INT333 = xu.maplog(gridderSym.data.transpose(),intlow,inthigh)

#plot
qxq_100 = np.copy(qxq108) 
qzq_100 = np.copy(qzq108) 
INT_100 = np.copy(INT108)


exec("fig"+fign+" = plt.figure("+fign+"); plt.clf()")
exec("ax"+fign+" = fig"+fign+".add_subplot(155)")
exec("cf"+fign+" = plt.contourf(qxq_100,qzq_100,INT_100,100)")
plt.axis('normal')



#exec("cf"+fign+".set_clim(0.5,5.0)")
exec("cf"+fign+".set_clim("+str(INT_100.min()+0.1)+","+str(INT_100.max()+0.1)+")")
exec("cf"+fign+".cmap.set_under('w')")

exec("cbar = plt.colorbar(cf"+fign+",ticks=[1.60, 2.0, 2.40, 2.8, 3.2, 3.6, 4.0],format='%.1f')")
cbar.set_label(r'$\log($Int$)$ (a.u.)', fontsize=tickf,**plfont)

plt.axvline(x=-1.82, color='k', linewidth=2, linestyle='--')
#
plt.xlim(-1.9,-1.75)
plt.ylim(7.625,7.775)
plt.xticks([-1.87,-1.78],fontsize=tickf)

ax1.yaxis.set_major_formatter(plt.NullFormatter())


##########################################################################################################
#-------------------93%-Ge  -  108-az-444------------------------------------------------------------------------------
##########################################################################################################
    
sample = 'GaAs_SiGe93_h05797'
samplename = 'GaAs-Cores-SiGe93-Shell_h05797'


titlestr = sample+" (108) az(444)"
scannr ='00438'
fign='1'

[uom,uchi,uphi,utt] = expcub.Q2Ang([0, -0.011077928870986978, 7.703177366253125], geometry = "real", trans=False)
[omth,dummy,dummy,ttth] = expcub.Q2Ang(GaAs.Q(4,4,4))
omoff444 = uom-omth
ttoff444 = utt-ttth


#Combine Path + Filename
fnamefio='%s_%s'%(sample,scannr)

#Open FIO file    
filefio=os.path.join(path, fnamefio+".fio")
fiodata=os.path.join(path,sample+"_"+scannr,"mythen")

#Get Motor Values and detector images
mot_counters = []
mca_raw = []
mot_counters = create_header(filefio)
mca_raw = check_filform(fiodata)

#config psd
expcub.Ang2Q.init_linear('z+',cch,1280.,chpdeg=chpdeg,roi=roi2)

om = np.array(mot_counters["om"])
tt = np.array(mot_counters["tt"])

[qx108_az448,qy108_az448,qz108_az448] = expcub.Ang2Q.linear(om,tt,roi=roi2,delta=[omoff444,ttoff444])

gridderSym = xu.FuzzyGridder2D(1200,1250)

mca_raw108_az448 = xu.blockAveragePSD(mca_raw, 1, roi=roi2)

gridderSym(qy108_az448,qz108_az448,mca_raw108_az448[:,roi2[0]:roi2[1]])

qxq108 = gridderSym.xaxis
qzq108 = gridderSym.yaxis
INT108 = xu.maplog(gridderSym.data.transpose(),2.4, 0.0)

#plot
qxq_93 = np.copy(qxq108) 
qzq_93 = np.copy(qzq108) 
INT_93 = np.copy(INT108)

exec("ax"+fign+" = fig"+fign+".add_subplot(154)")
exec("cf"+fign+" = plt.contourf(qxq_93,qzq_93,INT_93,100)")
plt.axis('normal')

exec("cf"+fign+".set_clim("+str(INT_93.min()+0.1)+","+str(INT_93.max()+0.1)+")")
exec("cf"+fign+".cmap.set_under('w')")

plt.axvline(x=-1.82, color='k', linewidth=2, linestyle='--')
#
plt.xlim(-1.9,-1.75)
plt.ylim(7.625,7.775)
plt.xticks([-1.87,-1.78],fontsize=tickf)

ax1.yaxis.set_major_formatter(plt.NullFormatter())

##########################################################################################################
#-------------------86%-Ge - 108-az-448------------------------------------------------------------------------------
##########################################################################################################
sample = 'GaAs_SiGe86_h05807'
samplename = 'GaAs-Cores-SiGe86-Shell_h05807'

titlestr = sample+" (108) az(448)"
scannr ='00328'
fign='1'

#Combine Path + Filename
fnamefio='%s_%s'%(sample,scannr)

#Open FIO file    
filefio=os.path.join(path, fnamefio+".fio")
fiodata=os.path.join(path,sample+"_"+scannr,"mythen")

#Get Motor Values and detector images
mot_counters = []
mca_raw = []
mot_counters = create_header(filefio)
mca_raw = check_filform(fiodata)

#config psd
expcub.Ang2Q.init_linear('z+',cch,1280.,chpdeg=chpdeg,roi=roi2)

om = np.array(mot_counters["om"])
tt = np.array(mot_counters["tt"])

#Offsets come from 448-Map
omoff448 = 0.0089782574368229
ttoff448 = 0.034319454026785934

[qx108_az448,qy108_az448,qz108_az448] = expcub.Ang2Q.linear(om,tt,roi=roi2,delta=[omoff448,ttoff448])
#[qx108_az448,qy108_az448,qz108_az448] = expcub.Ang2Q.linear(om,tt,roi=roi2)
#convert to RSM

gridderSym = xu.FuzzyGridder2D(1200,1250)

mca_raw108_az448 = xu.blockAveragePSD(mca_raw, 1, roi=roi2)

gridderSym(qy108_az448,qz108_az448,mca_raw108_az448[:,roi2[0]:roi2[1]])

qxq108 = gridderSym.xaxis
qzq108 = gridderSym.yaxis
INT108 = xu.maplog(gridderSym.data.transpose(),3.7,0.0)

#plot
qxq_86 = np.copy(qxq108) 
qzq_86 = np.copy(qzq108) 
INT_86 = np.copy(INT108)

exec("ax"+fign+" = fig"+fign+".add_subplot(153)")
exec("cf"+fign+" = plt.contourf(qxq_86,qzq_86,INT_86,100)")
plt.axis('normal')
plt.xlabel(r'$Q_{y}$ ($\AA^{-1}$)',fontsize=labf,**plfont)
plt.xlabel(r'$Q_{in plane}$ ($\AA^{-1}$)',fontsize=labf,**plfont)

exec("cf"+fign+".set_clim("+str(INT_86.min()+0.1)+","+str(INT_86.max()+0.1)+")")
exec("cf"+fign+".cmap.set_under('w')")

plt.axvline(x=-1.82, color='k', linewidth=2, linestyle='--')
#
plt.xlim(-1.9,-1.75)
plt.ylim(7.625,7.775)
plt.xticks([-1.87,-1.78],fontsize=tickf)

ax1.yaxis.set_major_formatter(plt.NullFormatter())

##########################################################################################################
#-------------------77%-Ge 108-az-448------------------------------------------------------------------------------
##########################################################################################################
sample = 'GaAs_SiGe77_h05798'
samplename = 'GaAs-Cores-SiGe77-Shell_h05798'

titlestr = sample+" (108) az(108)"
scannr ='00400'
fign='1'

[uom,uchi,uphi,utt] = expcub.Q2Ang([0, -0.0018623800394116346, 7.702836005056157], geometry = "real", trans=False) 
[omth,dummy,dummy,ttth] = expcub.Q2Ang(GaAs.Q(4,4,4))
omoff444 = uom-omth
ttoff444 = utt-ttth

#Combine Path + Filename
fnamefio='%s_%s'%(sample,scannr)

#Open FIO file    
filefio=os.path.join(path, fnamefio+".fio")
fiodata=os.path.join(path,sample+"_"+scannr,"mythen")

#Get Motor Values and detector images
mot_counters = []
mca_raw = []
mot_counters = create_header(filefio)
mca_raw = check_filform(fiodata)

#config psd
expcub.Ang2Q.init_linear('z+',cch,1280.,chpdeg=chpdeg,roi=roi2)

om = np.array(mot_counters["om"])
tt = np.array(mot_counters["tt"])

[qx108_az108_1,qy108_az108_1,qz108_az108_1] = expcub.Ang2Q.linear(om,tt,roi=roi2,delta=[omoff444,ttoff444])

gridderSym = xu.FuzzyGridder2D(1200,1250)

mca_raw108_az108_1 = xu.blockAveragePSD(mca_raw, 1, roi=roi2)

gridderSym(qy108_az108_1,qz108_az108_1,mca_raw108_az108_1[:,roi2[0]:roi2[1]])

qxq108 = gridderSym.xaxis
qzq108 = gridderSym.yaxis
INT108 = xu.maplog(gridderSym.data.transpose(),2.2,0.0)

#plot
qxq_77 = np.copy(qxq108) 
qzq_77 = np.copy(qzq108) 
INT_77 = np.copy(INT108)

exec("ax"+fign+" = fig"+fign+".add_subplot(152)")
exec("cf"+fign+" = plt.contourf(qxq_77,qzq_77,INT_77,100)")
plt.axis('normal')

exec("cf"+fign+".set_clim("+str(INT_77.min()+0.1)+","+str(INT_77.max()+0.1)+")")
exec("cf"+fign+".cmap.set_under('w')")

plt.axvline(x=-1.82, color='k', linewidth=2, linestyle='--')
#
plt.xlim(-1.9,-1.75)
plt.ylim(7.625,7.775)
plt.xticks([-1.87,-1.78],fontsize=tickf)

ax1.yaxis.set_major_formatter(plt.NullFormatter())

##########################################################################################################
#-------------------63% Germanium - 108-az-448------------------------------------------------------------------------------
##########################################################################################################
sample = 'GaAs_SiGe67_h05798'
samplename = 'GaAs-Cores-Ge(67%)-Shell_h05789'

titlestr = sample+" (108) az(448)"
scannr ='00492'
fign='1'

[uom,uchi,uphi,utt] = expcub.Q2Ang([0, -3.6282879669706496, 10.27174764704892], geometry = "real", trans=False) 
[omth,dummy,dummy,ttth] = expcub.Q2Ang(GaAs.Q(4,4,8))
omoff448 = uom-omth
ttoff448 = utt-ttth

#Combine Path + Filename
fnamefio='%s_%s'%(sample,scannr)

#Open FIO file    
filefio=os.path.join(path, fnamefio+".fio")
fiodata=os.path.join(path,sample+"_"+scannr,"mythen")

#Get Motor Values and detector images
mot_counters = []
mca_raw = []
mot_counters = create_header(filefio)
mca_raw = check_filform(fiodata)

#config psd
expcub.Ang2Q.init_linear('z+',cch,1280.,chpdeg=chpdeg,roi=roi2)

om = np.array(mot_counters["om"])
tt = np.array(mot_counters["tt"])

[qx108_az448,qy108_az448,qz108_az448] = expcub.Ang2Q.linear(om,tt,roi=roi2,delta=[omoff448,ttoff448])

gridderSym = xu.FuzzyGridder2D(1200,1250)

mca_raw108_az448 = xu.blockAveragePSD(mca_raw, 1, roi=roi2)

gridderSym(qy108_az448,qz108_az448,mca_raw108_az448[:,roi2[0]:roi2[1]])

qxq108 = gridderSym.xaxis
qzq108 = gridderSym.yaxis
INT108 = xu.maplog(gridderSym.data.transpose(),2.2,0.0)

#plot
qxq_63 = np.copy(qxq108) 
qzq_63 = np.copy(qzq108) 
INT_63 = np.copy(INT108)

exec("ax"+fign+" = fig"+fign+".add_subplot(151)")
exec("cf"+fign+" = plt.contourf(qxq_63,qzq_63,INT_63,100)")
plt.axis('normal')
plt.ylabel(r'$Q_{out of plane}$ ($\AA^{-1}$)',fontsize=labf,**plfont)

exec("cf"+fign+".set_clim("+str(INT_63.min()+0.02)+","+str(INT_63.max()+0.1)+")")
exec("cf"+fign+".cmap.set_under('w')")

plt.axvline(x=-1.82, color='k', linewidth=2, linestyle='--')
#
plt.xlim(-1.9,-1.75)
plt.ylim(7.625,7.775)
plt.xticks([-1.87,-1.78],fontsize=tickf)


########################################################################################


exec("fig"+fign+".set_size_inches(18, 12, forward=True)")

plt.tight_layout()

cf1 = plt.subplots_adjust(wspace = 0.02, hspace = 0.01)

if sav:
    plt.savefig('Fig2.png', format='png', dpi=600)

    